
class Point {
public:
    int x, y;
    Point(int x=0, int y=0): x(x), y(y) {}
    Point operator+(Point p) {
        return Point(x+p.x, y+p.y);
    }
    Point & operator ++ () {  // Prefix increment
        ++x;
        ++y;
        return *this;
    }
    Point operator++(int) { // Postfix increment. Notice the
        // unused parameter.
        Point p(x,y);
        ++x;
        ++y;
        return p;
    }
};

istream & operator >> (istream &in, Point &p) {
    char lparen, comma, rparen;
    in >> lparen;
    if (lparen != '(') in.setstate(std::ios_base::failbit);
    in >> p.x;
    in >> comma;
    if (comma != ',') in.setstate(std::ios_base::failbit);
    in >> p.y;
    in >> rparen;
    if (rparen != ')') in.setstate(std::ios_base::failbit);
    return in;
}

ostream & operator << (ostream &out, Point p) {
    out << '(' << p.x << ", " << p.y << ')';
    return out;
}

int main() {
    Point p(19,-7), q;
    q = p++;
    cout << "Value of p before incrementing is " << q << "." << endl;
    p = q;
    cout << "Value of p after incrementing is " << ++p << endl;
	return 0;
}
